define([
        "cdes/core/CdesVoc",
        "clazzes/TinyLog",
        "dojo/json",
        "dojo/string",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         CdesVoc,
         TinyLog,
         json,
         string,
         lang,
         i18n
         ) {
    
    var className = "at.cdes.web.util.I18nHelper";
    
    var log = new TinyLog(className);
    
    var I18nHelper = {

        getCurrentLocaleString : function(jsonString, locale) {
            var localeToTranslation = I18nHelper.getLocaleMap(jsonString, locale);
            if (locale in localeToTranslation) {
                return localeToTranslation[locale];
            } else {
                for (var currLocale in localeToTranslation) {
                    return localeToTranslation[currLocale];
                }
                return "";
            }
        },

        getLocaleMap : function(jsonString, locale) {
            var localeToTranslation;
            if (jsonString != null && jsonString.trim().indexOf("{") == 0) {
                try {
                    localeToTranslation = json.parse(jsonString);
                } catch (e) {
                    // Probably illegal json, continue as if we would have received a plain string
                    localeToTranslation = new Object();
                    if (jsonString != null) {
                        localeToTranslation[locale] = jsonString;
                    }    
                }
            } else {
                localeToTranslation = new Object();
                if (jsonString != null) {
                    localeToTranslation[locale] = jsonString;
                }
            }
            return localeToTranslation;
        },

        updateCurrentLocaleString : function(oldLocaleMapString, newTranslation, locale) {
            var localeMap = I18nHelper.getLocaleMap(oldLocaleMapString, locale);
            localeMap[locale] = newTranslation;
            var newLocaleMapString = json.stringify(localeMap);
            return newLocaleMapString;
        },

        getLocaleLabel : function(locale) {
            if (locale == "de") {
                return i18n.german;
            } else if (locale == "sl") {
                return i18n.slovene;
            } else if (locale == "en") {
                return i18n.english;
            } else {
                return locale;
            }
        }
    };
    return I18nHelper;
});
